Scriptname MinervaMCMScript extends Ski_Configbase  Conditional


; Minerva Follower Mod Configuration Menu (MCM) script


; Authors:
;
; Rxkx22 - Original follower idea, design, and creation
; cloudedtruth - All dialogue, scripts, spells, and other misc parts of the mod




;### Begin Code ###;


; Imports

Import Game
Import Utility
Import Math


; Global Variables

GlobalVariable Property aaa_MinervaDialogueOption Auto

; Actors

Actor Property aaa_Minerva Auto
Actor Property PlayerRef Auto			; NEVER use Game.GetPlayer(), always use PlayerRef. The Game.GetPlayer() method is very slow and require more processing than PlayerRef.


; Aliases

ReferenceAlias property MinervaTeammateAlias Auto


; Factions

Faction Property CurrentFollowerFaction Auto
Faction Property PlayerMarriedFaction Auto


; Locations

Location Property SovngardeLocation Auto
Location Property DarkBrotherhoodSanctuaryLocation Auto
Location Property IrkngthandLocation Auto
Location Property YsgramorsTombLocation Auto
Location Property SnowVeilSanctumLocation Auto
Location Property SolitudeCastleDourEmperorsTowerLocation Auto
Location Property BluePalaceWingLocation Auto
Location Property SkuldafnLocation Auto
Location Property NightingaleHallLocation Auto
Location Property TwilightSepulcherLocation Auto


; OIDs

int MinervaSneakOID
int MinervaLoverOID
int MinervaAllowAllOID
int MinervaIdleDialogueOID
int MinervaDialogueOptionsOID
int MinervaProtectEssentialOID
int MinervaExtraDialogueOID
int MinervaTeammateOID
int MinervaStopCombatOID
int MinervaStopCombatAlarmOID
int MinervaMoveToPlayerOID
int MinervaMoreFollowerHelloOID
int MinervaGenFollowerGoodbyeOID
int MinervaSpouseDialogueFixOID
int MinervaSetDispositionOID


; Toggle States

bool property MinervaSneakVal = True Auto Conditional
bool property MinervaLoverVal = False Auto Conditional
bool property MinervaAllowAllVal = False Auto Conditional
bool property MinervaIdleDialogueVal = True Auto Conditional
bool property MinervaDialogueOptionsVal = True Auto Conditional
bool property MinervaExtraDialogueVal = False Auto Conditional
bool property MinervaTeammateVal = False Auto Conditional
bool property MinervaMoreFollowerHelloVal = False Auto Conditional
bool property MinervaGenFollowerGoodbyeVal = False Auto Conditional
bool property MinervaSpouseDialogueFixVal = True Auto Conditional


; Functions

; Show Minerva's current protection status
String Function Minerva_GetProtectionStatus()
	String ProtectValue = ""

	If aaa_Minerva.GetActorBase().IsEssential()
		Return "Essential"
	ElseIf aaa_Minerva.GetActorBase().IsProtected()
		Return "Protected"
	Else
		Return "UnProtected"
	EndIf
	Return ProtectValue
EndFunction


; Change Minerva's protection status
String Function Minerva_SetProtectionStatus()
	String ProtectValue = ""

	If !aaa_Minerva.GetActorBase().IsProtected() && !aaa_Minerva.GetActorBase().IsEssential()
		aaa_Minerva.GetActorBase().SetProtected()
		ProtectValue = "Protected"
	ElseIf aaa_Minerva.GetActorBase().IsProtected()
		aaa_Minerva.GetActorBase().SetProtected(False)
		aaa_Minerva.GetActorBase().SetEssential()
		ProtectValue = "Essential"
	Else
		aaa_Minerva.GetActorBase().SetEssential(False)
		ProtectValue = "UnProtected"
	EndIf
	Return ProtectValue
EndFunction


Function Minerva_SetTeammate(ObjectReference MinervaRef)
	Actor MinervaActor = MinervaRef as Actor
	If !aaa_Minerva.IsPlayerTeammate()
		aaa_Minerva.SetPlayerTeammate()
		MinervaTeammateAlias.ForceRefTo(MinervaActor)
		aaa_Minerva.IgnoreFriendlyHits()
		aaa_Minerva.EvaluatePackage()
	Else
		aaa_Minerva.SetPlayerTeammate(False)
		aaa_Minerva.SetActorValue("WaitingforPlayer", 0)
		MinervaTeammateAlias.Clear()
		aaa_Minerva.IgnoreFriendlyHits(False)
		aaa_Minerva.EvaluatePackage()
	EndIf
EndFunction


; To allow SKSE users to turn off the in-game dialogue option while
; allowing non SKSE users to use the dialogue option at the same time,
; a global variable is used to control this.
; Since variables from this script can't be accessed by the game for
; non SKSE users.
 
Function Minerva_SetDialogueGlobal()
	If MinervaDialogueOptionsVal == False
		aaa_MinervaDialogueOption.SetValue(0.0)
	Else
		aaa_MinervaDialogueOption.SetValue(1.0)
	EndIf
EndFunction


; Check to make sure the player is not in a location normally blocked for followers
; and disable the teleport Minerva option if the player is in one of those locations

bool Function MinervaTeleLocationValid()
	If !PlayerRef.IsInLocation(SovngardeLocation) && !PlayerRef.IsInLocation(DarkBrotherhoodSanctuaryLocation) && !PlayerRef.IsInLocation(IrkngthandLocation) && \
	!PlayerRef.IsInLocation(YsgramorsTombLocation) && !PlayerRef.IsInLocation(SnowVeilSanctumLocation) && !PlayerRef.IsInLocation(SolitudeCastleDourEmperorsTowerLocation) && \
	!PlayerRef.IsInLocation(BluePalaceWingLocation) && !PlayerRef.IsInLocation(SkuldafnLocation) && !PlayerRef.IsInLocation(NightingaleHallLocation) && !PlayerRef.IsInLocation(TwilightSepulcherLocation)
		Return True
	EndIf
	Return False
EndFunction


String Function Minerva_ShowDisposition()
	String CurrentRank = ""
	If aaa_Minerva.GetRelationshipRank(PlayerRef) == -2
		CurrentRank = "-2 = Rival"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == -1
		CurrentRank = "-1 = Foe"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == 0
		CurrentRank = "0 = Acquaintance"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == 1
		CurrentRank = "1 = Friend"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == 2
		CurrentRank = "2 = Confident"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == 3
		CurrentRank = "3 = Ally"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == 4
		CurrentRank = "4 = Lover"
	EndIf
	Return CurrentRank
EndFunction


String Function Minerva_SetDisposition()
	String SetRankTo = ""
	If aaa_Minerva.GetRelationshipRank(PlayerRef) == -2
		aaa_Minerva.SetRelationshipRank((PlayerRef), -1)
		SetRankTo = "-1 = Foe"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == -1
		aaa_Minerva.SetRelationshipRank((PlayerRef), 0)
		SetRankTo = "0 = Acquaintance"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == 0
		aaa_Minerva.SetRelationshipRank((PlayerRef), 1)
		SetRankTo = "1 = Friend"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == 1
		aaa_Minerva.SetRelationshipRank((PlayerRef), 2)
		SetRankTo = "2 = Confident"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == 2
		aaa_Minerva.SetRelationshipRank((PlayerRef), 3)
		SetRankTo = "3 = Ally"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == 3
		aaa_Minerva.SetRelationshipRank((PlayerRef), 4)
		SetRankTo = "4 = Lover"
	ElseIf aaa_Minerva.GetRelationshipRank(PlayerRef) == 4
		aaa_Minerva.SetRelationshipRank((PlayerRef), 1)
		SetRankTo = "1 = Friend"
	EndIf
	Return SetRankTo
EndFunction


; Version of the script
int Function GetVersion()
	return 1 ; default version
EndFunction


; Start MCM

Event OnConfigInit()
	Pages = new string[2]
	Pages[0] = "Settings"
	Pages[1] = "Troubleshooting"
EndEvent


; When script is updated that adds new content, run this event.
Event OnVersionUpdate(int a_version)

EndEvent


Event OnPageReset(string page)
	If (page == "")
		SetTitleText("Minerva Follower")
		LoadCustomContent("Minerva/MinervaMCMImage.dds", 0.0, 0.0)
		return
	Else
		UnloadCustomContent()
	EndIf

	If (page == "Settings")
		SetTitleText("Minerva Follower Settings")
		SetCursorFillMode(TOP_TO_BOTTOM)
		SetCursorPosition(0) ;SE
		AddHeaderOption("Dialogue Settings")

		MinervaSneakOID = AddToggleOption("Sneak Dialogue", MinervaSneakVal)

		MinervaLoverOID = AddToggleOption("Lover Dialogue", MinervaLoverVal)

		MinervaIdleDialogueOID = AddToggleOption("Follower Idle Dialogue", MinervaIdleDialogueVal)

		MinervaAllowAllOID = AddToggleOption("Allow Dialogue For Others", MinervaAllowAllVal)
		
		MinervaSpouseDialogueFixOID = AddToggleOption("Adjusted Spouse Dialogue", MinervaSpouseDialogueFixVal)

		AddEmptyOption()

		AddHeaderOption("Extra Dialogue")

		MinervaExtraDialogueOID = AddToggleOption("Extra Follower Goodbye Lines", MinervaExtraDialogueVal)

		MinervaGenFollowerGoodbyeOID = AddToggleOption("Generic Follower Goodbye Lines", MinervaGenFollowerGoodbyeVal)

		MinervaMoreFollowerHelloOID = AddToggleOption("More Follower Hello Lines", MinervaMoreFollowerHelloVal)

		SetCursorPosition(1)
		AddHeaderOption("General Settings")

		MinervaDialogueOptionsOID = AddToggleOption("Allow In-Game Dialogue Options", MinervaDialogueOptionsVal)

		AddEmptyOption()

		MinervaProtectEssentialOID = AddTextOption("Minerva's Protection Status", Minerva_GetProtectionStatus())

		AddEmptyOption()

		If !aaa_Minerva.IsInFaction(CurrentFollowerFaction)
			MinervaTeammateOID = AddToggleOption("Make Minerva a Teammate", MinervaTeammateVal)
		Else
			MinervaTeammateOID = AddToggleOption("Make Minerva a Teammate", MinervaTeammateVal, OPTION_FLAG_DISABLED)
		EndIf

	ElseIf (page == "Troubleshooting")
		SetTitleText("Minerva Follower Troubleshooting")
		SetCursorFillMode(TOP_TO_BOTTOM)
		SetCursorPosition(0) ;CT
		AddHeaderOption("Make Minerva Stop Combat")
		If aaa_Minerva.IsInCombat()
			MinervaStopCombatOID = AddTextOption("Click to stop combat", "")
		Else
			MinervaStopCombatOID = AddTextOption("Minerva is not in combat", "", OPTION_FLAG_DISABLED)
		EndIf
		
		AddEmptyOption()
		
		AddHeaderOption("Make Minerva and Enemies Stop Combat")
		If aaa_Minerva.IsInCombat()
			MinervaStopCombatAlarmOID = AddTextOption("Click to stop combat", "")
		Else
			MinervaStopCombatAlarmOID = AddTextOption("Minerva is not in combat", "", OPTION_FLAG_DISABLED)
		EndIf

		SetCursorPosition(1)
		AddHeaderOption("Move Minerva to You")
		If !(aaa_Minerva.GetParentCell() == PlayerRef.GetParentCell())
			If MinervaTeleLocationValid()
				MinervaMoveToPlayerOID = AddTextOption("Click to instantly move Minerva to you", "")
			Else
				MinervaMoveToPlayerOID = AddTextOption("Not a valid location for followers", "", OPTION_FLAG_DISABLED)
			EndIf
		Else
			MinervaMoveToPlayerOID = AddTextOption("Minerva is in the same cell as you", "", OPTION_FLAG_DISABLED)
		EndIf

		AddEmptyOption()

		AddHeaderOption("Fix Relationship Rank")
		If aaa_Minerva.GetRelationshipRank(PlayerRef) >= -2
			If !aaa_Minerva.IsInFaction(PlayerMarriedFaction)
				MinervaSetDispositionOID = AddTextOption("Minerva's current rank", Minerva_ShowDisposition())
			Else
				MinervaSetDispositionOID = AddTextOption("Minerva is your spouse!", "", OPTION_FLAG_DISABLED)
			EndIf
		Else
			MinervaSetDispositionOID = AddTextOption("Minerva is your enemy", "", OPTION_FLAG_DISABLED)
		EndIf
	EndIf
EndEvent

Event OnOptionSelect(int option)
	If (option == MinervaSneakOID)
		MinervaSneakVal = !MinervaSneakVal
		SetToggleOptionValue(MinervaSneakOID, MinervaSneakVal)
	ElseIf (option == MinervaLoverOID)
		MinervaLoverVal = !MinervaLoverVal
		SetToggleOptionValue(MinervaLoverOID, MinervaLoverVal)
	ElseIf (option == MinervaAllowAllOID)
		MinervaAllowAllVal = !MinervaAllowAllVal
		SetToggleOptionValue(MinervaAllowAllOID, MinervaAllowAllVal)
	ElseIf (option == MinervaIdleDialogueOID)
		MinervaIdleDialogueVal = !MinervaIdleDialogueVal
		SetToggleOptionValue(MinervaIdleDialogueOID, MinervaIdleDialogueVal)
	ElseIf (option == MinervaProtectEssentialOID)
		SetTextOptionValue(MinervaProtectEssentialOID, Minerva_SetProtectionStatus())
	ElseIf (option == MinervaDialogueOptionsOID) ;CT
		MinervaDialogueOptionsVal = !MinervaDialogueOptionsVal
		SetToggleOptionValue(MinervaDialogueOptionsOID, MinervaDialogueOptionsVal)
		Minerva_SetDialogueGlobal()
	ElseIf (option == MinervaExtraDialogueOID)
		MinervaExtraDialogueVal = !MinervaExtraDialogueVal
		SetToggleOptionValue(MinervaExtraDialogueOID, MinervaExtraDialogueVal)
	ElseIf (option == MinervaMoreFollowerHelloOID)
		MinervaMoreFollowerHelloVal = !MinervaMoreFollowerHelloVal
		SetToggleOptionValue(MinervaMoreFollowerHelloOID, MinervaMoreFollowerHelloVal)
	ElseIf (option == MinervaGenFollowerGoodbyeOID)
		MinervaGenFollowerGoodbyeVal = !MinervaGenFollowerGoodbyeVal
		SetToggleOptionValue(MinervaGenFollowerGoodbyeOID, MinervaGenFollowerGoodbyeVal)
	ElseIf (option == MinervaSpouseDialogueFixOID)
		MinervaSpouseDialogueFixVal = !MinervaSpouseDialogueFixVal
		SetToggleOptionValue(MinervaSpouseDialogueFixOID, MinervaSpouseDialogueFixVal)
	ElseIf (option == MinervaTeammateOID)
		MinervaTeammateVal = !MinervaTeammateVal
		Minerva_SetTeammate(aaa_Minerva)
		SetToggleOptionValue(MinervaTeammateOID, MinervaTeammateVal)
		ForcePageReset()
	ElseIf (option == MinervaStopCombatOID)
		SetTextOptionValue(MinervaStopCombatOID, "")
		aaa_Minerva.StopCombat()
		ShowMessage("Forced Minerva to stop combat.")
	ElseIf (option == MinervaStopCombatAlarmOID)
		SetTextOptionValue(MinervaStopCombatAlarmOID, "")
		aaa_Minerva.StopCombatAlarm()
		ShowMessage("Forced Minerva and all enemies fighting her to stop combat.")
	ElseIf (option == MinervaMoveToPlayerOID) ;CT
		SetTextOptionValue(MinervaMoveToPlayerOID, "")
		aaa_Minerva.MoveTo(PlayerRef, -200.0 * Math.Sin(PlayerRef.GetAngleZ()), -200.0 * Math.Cos(PlayerRef.GetAngleZ()), PlayerRef.GetHeight())
		ShowMessage("Moved Minerva to your position.\nShe should appear behind you.")
		ForcePageReset()
	ElseIf (option == MinervaSetDispositionOID)
		SetTextOptionValue(MinervaSetDispositionOID, Minerva_SetDisposition())
	EndIf
EndEvent

Event OnOptionHighlight(int option)
	If (option == MinervaSneakOID)
		SetInfoText("Turn on or off Minerva's dialogue when sneaking.\nDefault = On.")
	ElseIf (option == MinervaLoverOID)
		SetInfoText("Turn on or off Minerva's lover dialogue.\nIf you marry Minerva, she will always use lover dialogue.\nDefault = Off.")
	ElseIf (option == MinervaAllowAllOID)
		SetInfoText("This will allow other Female Elf Haughty voiced NPCs to use Minerva's dialogue.\nA NPC must be a least a friend of the player in order to use the dialogue.\nDefault = Off.")
	ElseIf (option == MinervaIdleDialogueOID)
		SetInfoText("Turn on or off all of Minerva's follower idle dialogue.\nDefault = On.")
	ElseIf (option == MinervaProtectEssentialOID)
		SetInfoText("Click to change Minerva's protection status.\nEssential = Unkillable, Protected = Only killable by Player, Unprotected = Can die by any means.\nIf you do not want to allow Minerva to be killed, do not change this from the default setting.\nBy default, Minerva is Essential. I strongly recommend leaving set to that.")
	ElseIf (option == MinervaDialogueOptionsOID)
		SetInfoText("Turn on or off the in-game dialogue option: 'Let's talk about your dialogue.'\nOff is HIGHLY recommended as the MCM options give better control over the dialogue configurations.\nDefault = On (For non SKSE/SkyUI users).")
	ElseIf (option == MinervaExtraDialogueOID)
		SetInfoText("Allow extra follower goodbye dialogue to be used which may be less fitting or less applicable than the standard dialogue.\nOff is recommended unless you don't mind these kind of lines.\nDefault = Off.")
	ElseIf (option == MinervaMoreFollowerHelloOID)
		SetInfoText("Allow more follower hello lines to be used.\nThese are shorter than the standed ones, and are somewhat similar to generic dialogue.\nI recommend you try turning this on if you tire of the standard follower hello lines.\nDefault = Off.")
	ElseIf (option == MinervaGenFollowerGoodbyeOID)
		SetInfoText("Allow more generic follower goodbye lines to be used.\nThese include such lines as: 'All right, then' and 'Hmm hmm'. She will NOT say 'Until next time'.\nOn is generally recommended so her follower goodbye lines have more variation.\nDefault = Off.")
	ElseIf (option == MinervaSpouseDialogueFixOID)
		SetInfoText("Allows for slightly altered spouse dialogue to be used.\nNOTE: No original game records were altered, so it will not conflict with any other mod.\nOn is recommended, unless you prefer the vanilla spouse dialogue.\nDefault = On.")
	ElseIf (option == MinervaTeammateOID)
		SetInfoText("WARNING! Please read this!\nI do NOT recommend using this option. Only use if you have a conflicting follower overhaul.\nThis allows Minerva to follow the player like normal followers, but may NOT always work correctly.\nTo dismiss Minerva as a teammate, uncheck this option.")
	ElseIf (option == MinervaStopCombatOID)
		SetInfoText("This will make Minerva temporarily stop combat.\nIf she becomes stuck and is unresponsive at some point at the end of combat,\nselect this option to make her stop fighting and allow you to talk with her again.")
	ElseIf (option == MinervaStopCombatAlarmOID)
		SetInfoText("This will make Minerva and all enemies fighting her temporarily stop combat.\nIf she is fighting someone you don't want her to, or accidentally hit a neutral NPC and now is fighting him/her,\nselect this option to make Minerva and all her enemies temporarily stop fighting.")
	ElseIf (option == MinervaMoveToPlayerOID)
		SetInfoText("NOT recommended to use until you've met her in-game.\nThis will instantly move Minerva to you.\nNOTE: She may not always generate correctly when moved, especially when using HDT Physics.\nChanging cells will usually fix any abnormalities caused when moving her, if there are any.")
	ElseIf (option == MinervaSetDispositionOID)
		SetInfoText("Allows you to see, and change by clicking, Minerva's relationship rank with you.\nIf her rank gets messed up at any point, you can fix it here.\nNOTE: This option will be disabled if you cause her to turn hostile towards you.\nAlso, this option will be disabled if Minerva is your spouse.")
	EndIf
EndEvent